Rem SortParagraphs.vbs
Rem An InDesign VBScript
Rem
Rem Sorts the paragraphs in the selection in alphabetical order.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign scripting forum at http://www.adobeforums.com.
Rem
main
Function main()
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	If myInDesign.documents.Count <> 0 Then
	    If myInDesign.selection.Count > 0 Then
		Select Case TypeName(myInDesign.Selection.Item(1))
			Case "Text", "TextColumn", "TextFrame"
				If myInDesign.Selection.Item(1).Paragraphs.Count > 1 Then
					myDisplayDialog myInDesign
				Else
					MsgBox("Please select at least two paragraphs of text (or a text frame) try again.")
				End If
		    Case "Cell", "Row", "Column", "Table"
				MsgBox ("This script cannot sort table rows, columns, or cells." & vbCr & "Try converting the table to text, sorting" & vbCr & "the text, and then converting back to a table.")
			Case Else
				MsgBox ("Please select some text (or a text frame) try again.")
		End Select
	    Else
	        MsgBox ("Nothing is selected. Please select some text (or a text frame) try again.")
	    End If
	Else
	    MsgBox ("No documents are open. Please open a document and try again.")
	End If
End Function
Function myDisplayDialog(myInDesign)
	Set myDialog = myInDesign.Dialogs.Add
	myDialog.Name = "Sort Options"
	With myDialog.DialogColumns.Add
		With .DialogRows.Add
			With .DialogColumns.Add
				With .StaticTexts.Add
					.StaticLabel = "Sort Method:"
				End With
			End With
			with .DialogColumns.Add
				Set mySortMethodDropdown = .Dropdowns.Add
				mySortMethodDropdown.stringList = Array("Ignore Formatting (faster)", "Retain Formatting (slower)")
				mySortMethodDropdown.selectedIndex = 0
			End With
		End With
		With .DialogRows.Add
			Set myIgnoreSpacesCheckbox = .checkboxControls.Add
			myIgnoreSpacesCheckbox.staticLabel = "Ignore Spaces"
			myIgnoreSpacesCheckbox.checkedState = True
		End With
		With .DialogRows.Add
			Set myReverseSortCheckbox = .checkboxControls.Add
			myReverseSortCheckbox.staticLabel = "Reverse Sort"
			myReverseSortCheckbox.checkedState = False
		End With
	End With
	myResult = myDialog.Show
	If myResult = True Then
		mySortMethod = mySortMethodDropdown.selectedIndex
		myIgnoreSpaces = myIgnoreSpacesCheckbox.checkedState
		myReverseSort = myReverseSortCheckbox.checkedState
		myDialog.Destroy
		mySortParagraphs myInDesign, mySortMethod, myIgnoreSpaces, myReverseSort
	Else
		myDialog.Destroy
	End If
End Function
Function mySortParagraphs(myInDesign, mySortMethod, myIgnoreSpaces, myReverseSort)
	Set myRegExp = New RegExp
	myRegExp.Pattern = "\s"
	myRegExp.IgnoreCase = True
    Set mySelection = myInDesign.selection.Item(1)
    If mySelection.Characters.Count <> 0 Then
        Set myParagraphs = mySelection.Paragraphs
    Else
        Set myParagraphs = mySelection.parentTextFrame.Paragraphs
    End If
    Rem If the last paragraph in the selection is the last paragraph of the story,
    Rem and if the last paragraph does not end in a carriage return character,
    Rem then add a carriage return character at the end of the last paragraph.
    If myParagraphs.Item(-1).Characters.Item(-1).Contents <> vbCr Then
        myParagraphs.Item(-1).insertionPoints.Item(-1).Contents = vbCr
        myCleanUp = True
    Else
        myCleanUp = False
    End If
	Rem Select Case statement added here to allow for others to add custom sort methods. To do this,
	Rem add another item to the dropdown menu in the dialog function, then add a corresponding
	Rem case in the Select Case block below.    
    Select Case mySortMethod
    	Case 0
    		Rem Convert the contents of the paragraphs to a single string.
    		myString = ""
    		For myCounter = 1 To myParagraphs.Count
    			myString = myString & myParagraphs.Item(myCounter).Contents
    		Next
    		Rem Pass the string to a JavaScript and get back a string.
    		myArray = Array(myString, myIgnoreSpaces, myReverseSort)
    		myJavaScript = myMakeJavaScript
    		myString = myInDesign.DoScript(myJavaScript, idScriptLanguage.idJavaScript, myArray)
    		Rem Replace the text range with the returned string.
			Set myStartCharacter = myParagraphs.Item(1).Characters.item(1)
			Set myEndCharacter = myParagraphs.Item(-1).Characters.Item(-1)
			Set myText = myParagraphs.Item(1).ParentStory.Texts.ItemByRange(myStartCharacter, myEndCharacter).Item(1)
			Rem Replace the contents with the string
			myText.Contents = myString
    	Case 1
		    Rem Simple bubble sort
		    If myReverseSort = False Then
			    Do
			        myItemMoved = False
			        myCounter = 1
			        Do While myCounter < myParagraphs.Count
			        	myStringA = LCase(myParagraphs.Item(myCounter).Contents)
			        	myStringB = LCase(myParagraphs.Item(myCounter + 1).Contents)
			        	If myIgnoreSpaces = True Then
							myStringA = myRegExp.Replace(myStringA, "")
							myStringB = myRegExp.Replace(myStringB, "")
			            End If
			            If myStringA > myStringB Then
			                myParagraphs.Item(myCounter).Move idAfter, myParagraphs.Item(myCounter + 1)
			                myItemMoved = True
			            End If
			            myCounter = myCounter + 1
			        Loop
			        myCounter = myEnd
			        Do While myCounter > 1
			        	myStringA = LCase(myParagraphs.Item(myCounter).Contents)
			        	myStringB = LCase(myParagraphs.Item(myCounter - 1).Contents)
			        	If myIgnoreSpaces = True Then
							myStringA = myRegExp.Replace(myStringA, "")
							myStringB = myRegExp.Replace(myStringB, "")
			            End If
			            If myStringA < myStringB Then
			                myParagraphs.Item(myCounter).Move idBefore, myParagraphs.Item(myCounter - 1)
			                myItemMoved = True
			            End If
			            myCounter = myCounter - 1
			        Loop
			        If myItemMoved = False Then
			            Exit Do
			        End If
			    Loop
		    Else
			    Do
			        myItemMoved = False
			        myCounter = 1
			        Do While myCounter < myParagraphs.Count
			        	myStringA = LCase(myParagraphs.Item(myCounter).Contents)
			        	myStringB = LCase(myParagraphs.Item(myCounter + 1).Contents)
			        	If myIgnoreSpaces = True Then
							myStringA = myRegExp.Replace(myStringA, "")
							myStringB = myRegExp.Replace(myStringB, "")
			            End If
			            If myStringA < myStringB Then
			                myParagraphs.Item(myCounter).Move idAfter, myParagraphs.Item(myCounter + 1)
			                myItemMoved = True
			            End If
			            myCounter = myCounter + 1
			        Loop
			        myCounter = myEnd
			        Do While myCounter > 1
			        	myStringA = LCase(myParagraphs.Item(myCounter).Contents)
			        	myStringB = LCase(myParagraphs.Item(myCounter - 1).Contents)
			        	If myIgnoreSpaces = True Then
							myStringA = myRegExp.Replace(myStringA, "")
							myStringB = myRegExp.Replace(myStringB, "")
			            End If
			            If myStringA > myStringB Then
			                myParagraphs.Item(myCounter).Move idBefore, myParagraphs.Item(myCounter - 1)
			                myItemMoved = True
			            End If
			            myCounter = myCounter - 1
			        Loop
			        If myItemMoved = False Then
			            Exit Do
			        End If
			    Loop		    
		    End If
    End Select
    Rem If we added a return at the end of the story, we should now
    Rem remove the extra return at the end of the story.
    If myCleanUp = True Then
        myParagraphs.Item(1).parentStory.Characters.Item(-1).Delete
    End If
End Function
Function myMakeJavaScript()
	myJavaScript = "myString = main(arguments[0], arguments[1], arguments[2]);" & vbCr
	myJavaScript = myJavaScript & "function main(myString, myIgnoreSpaces, myReverse){" & vbCr
	myJavaScript = myJavaScript & "	//JavaScript sort:" & vbCr
	myJavaScript = myJavaScript & "	var myArray = myString.split(""\r"");" & vbCr
	myJavaScript = myJavaScript & "	myString = """";" & vbCr
	myJavaScript = myJavaScript & "	if(myIgnoreSpaces != true){" & vbCr
	myJavaScript = myJavaScript & "		if(myReverse != true){" & vbCr
	myJavaScript = myJavaScript & "			myArray = myArray.sort(mySort);" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		else{" & vbCr
	myJavaScript = myJavaScript & "			myArray = myArray.sort(myReverseSort);" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "	}" & vbCr
	myJavaScript = myJavaScript & "	else{" & vbCr
	myJavaScript = myJavaScript & "		if(myReverse != true){" & vbCr
	myJavaScript = myJavaScript & "			myArray = myArray.sort(mySortIgnoringSpaces);" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		else{" & vbCr
	myJavaScript = myJavaScript & "			myArray = myArray.sort(myReverseSortIgnoringSpaces);" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "	}" & vbCr
	myJavaScript = myJavaScript & "	for(myCounter = 0; myCounter < myArray.length; myCounter ++){" & vbCr
	myJavaScript = myJavaScript & "		if(myArray[myCounter] != """"){" & vbCr
	myJavaScript = myJavaScript & "			myString += myArray[myCounter] + ""\r"";" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "	}" & vbCr
	myJavaScript = myJavaScript & "	return myString;" & vbCr
	myJavaScript = myJavaScript & "	//Sort functions." & vbCr
	myJavaScript = myJavaScript & "	function mySort(a, b){" & vbCr
	myJavaScript = myJavaScript & "		a = a.toLowerCase();" & vbCr
	myJavaScript = myJavaScript & "		b = b.toLowerCase();" & vbCr
	myJavaScript = myJavaScript & "		if(a > b){" & vbCr
	myJavaScript = myJavaScript & "			return 1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		if(a < b){" & vbCr
	myJavaScript = myJavaScript & "			return -1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		return 0;" & vbCr
	myJavaScript = myJavaScript & "	}" & vbCr
	myJavaScript = myJavaScript & "	function mySortIgnoringSpaces(a, b){" & vbCr
	myJavaScript = myJavaScript & "		var myRegExp = /\s/gi;" & vbCr
	myJavaScript = myJavaScript & "		a = a.toLowerCase().replace(myRegExp, """");" & vbCr
	myJavaScript = myJavaScript & "		b = b.toLowerCase().replace(myRegExp, """");" & vbCr
	myJavaScript = myJavaScript & "		if(a > b){" & vbCr
	myJavaScript = myJavaScript & "			return 1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		if(a < b){" & vbCr
	myJavaScript = myJavaScript & "			return -1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		return 0;" & vbCr
	myJavaScript = myJavaScript & "	}" & vbCr
	myJavaScript = myJavaScript & "	function myReverseSort(a, b){" & vbCr
	myJavaScript = myJavaScript & "		a = a.toLowerCase();" & vbCr
	myJavaScript = myJavaScript & "		b = b.toLowerCase();" & vbCr
	myJavaScript = myJavaScript & "		if(a > b){" & vbCr
	myJavaScript = myJavaScript & "			return -1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		if(a < b){" & vbCr
	myJavaScript = myJavaScript & "			return 1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		return 0;" & vbCr
	myJavaScript = myJavaScript & "	}" & vbCr
	myJavaScript = myJavaScript & "	function myReverseSortIgnoringSpaces(a, b){" & vbCr
	myJavaScript = myJavaScript & "		var myRegExp = /\s/gi;" & vbCr
	myJavaScript = myJavaScript & "		a = a.toLowerCase().replace(myRegExp, """");" & vbCr
	myJavaScript = myJavaScript & "		b = b.toLowerCase().replace(myRegExp, """");" & vbCr
	myJavaScript = myJavaScript & "		if(a > b){" & vbCr
	myJavaScript = myJavaScript & "			return -1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		if(a < b){" & vbCr
	myJavaScript = myJavaScript & "			return 1;" & vbCr
	myJavaScript = myJavaScript & "		}" & vbCr
	myJavaScript = myJavaScript & "		return 0;" & vbCr
	myJavaScript = myJavaScript & "	}	" & vbCr
	myJavaScript = myJavaScript & "}" & vbCr
	myMakeJavaScript = myJavaScript
End Function
'' SIG '' Begin signature block
'' SIG '' MIIeVAYJKoZIhvcNAQcCoIIeRTCCHkECAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' fhxdjABdd3l4hmGOcWNDIqKSU97iaBCJLPNHgkfm0X+g
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERgwghEUAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIPy14tfPzyiW
'' SIG '' a4zOvJAYv2v/6WnFaFnOp0LY3HxzUVEwMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAgbsH7yc8
'' SIG '' ozkTzHXLZDnVccVkNyzrReQ1YHdawwoNTvv7FcbQjCT5
'' SIG '' YARnWZdNKR1pGWN0ie56L3b+ZqHONZ4ejGSbFABoBP1W
'' SIG '' EW/lIuaM+Au0VHd6HgMUQsj3W4EJZ+eiCXPsCvVopr8W
'' SIG '' Zm7ZJ6Hmhx1Vd0zQHXlfvmNoyRcISGObXuEA/a+N7Zuk
'' SIG '' HbopkKkvJMedcEkmLHJ7yzcSaR6G9FivcQT8NqaY765q
'' SIG '' xAIRZPZk7KesWntyjMDec9UsgOyTAZlYiVQeP5sJaiar
'' SIG '' nzln+PmZaEyuy7lMlbNpsVY4N4P0tKxNoqTd2GDJ4zK9
'' SIG '' gx6+qjkwZObjtpSGIlbFrPfU+6GCDskwgg7FBgorBgEE
'' SIG '' AYI3AwMBMYIOtTCCDrEGCSqGSIb3DQEHAqCCDqIwgg6e
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCDiWkK0Xdyp0+5rzImGlVEL0eu/7nwp6Hs6
'' SIG '' +fJXnaPWMAIRAOUYXtufnxjxsOe8LmQRjIsYDzIwMjAx
'' SIG '' MDA0MDAyMTAwWqCCC7swggaCMIIFaqADAgECAhAEzT+F
'' SIG '' aK52xhuw/nFgzKdtMA0GCSqGSIb3DQEBCwUAMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0EwHhcNMTkxMDAxMDAwMDAwWhcNMzAx
'' SIG '' MDE3MDAwMDAwWjBMMQswCQYDVQQGEwJVUzEXMBUGA1UE
'' SIG '' ChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG1RJTUVT
'' SIG '' VEFNUC1TSEEyNTYtMjAxOS0xMC0xNTCCASIwDQYJKoZI
'' SIG '' hvcNAQEBBQADggEPADCCAQoCggEBAOlkNZz6qZhlZBvk
'' SIG '' F9y4KTbMZwlYhU0w4Mn/5Ts8EShQrwcx4l0JGML2iYxp
'' SIG '' CAQj4HctnRXluOihao7/1K7Sehbv+EG1HTl1wc8vp6xF
'' SIG '' fpRtrAMBmTxiPn56/UWXMbT6t9lCPqdVm99aT1gCqDJp
'' SIG '' IhO+i4Itxpira5u0yfJlEQx0DbLwCJZ0xOiySKKhFKX4
'' SIG '' +uGJcEQ7je/7pPTDub0ULOsMKCclgKsQSxYSYAtpIoxO
'' SIG '' zcbVsmVZIeB8LBKNcA6Pisrg09ezOXdQ0EIsLnrOnGd6
'' SIG '' OHdUQP9PlQQg1OvIzocUCP4dgN3Q5yt46r8fcMbuQhZT
'' SIG '' NkWbUxlJYp16ApuVFKMCAwEAAaOCAzgwggM0MA4GA1Ud
'' SIG '' DwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB
'' SIG '' /wQMMAoGCCsGAQUFBwMIMIIBvwYDVR0gBIIBtjCCAbIw
'' SIG '' ggGhBglghkgBhv1sBwEwggGSMCgGCCsGAQUFBwIBFhxo
'' SIG '' dHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMIIBZAYI
'' SIG '' KwYBBQUHAgIwggFWHoIBUgBBAG4AeQAgAHUAcwBlACAA
'' SIG '' bwBmACAAdABoAGkAcwAgAEMAZQByAHQAaQBmAGkAYwBh
'' SIG '' AHQAZQAgAGMAbwBuAHMAdABpAHQAdQB0AGUAcwAgAGEA
'' SIG '' YwBjAGUAcAB0AGEAbgBjAGUAIABvAGYAIAB0AGgAZQAg
'' SIG '' AEQAaQBnAGkAQwBlAHIAdAAgAEMAUAAvAEMAUABTACAA
'' SIG '' YQBuAGQAIAB0AGgAZQAgAFIAZQBsAHkAaQBuAGcAIABQ
'' SIG '' AGEAcgB0AHkAIABBAGcAcgBlAGUAbQBlAG4AdAAgAHcA
'' SIG '' aABpAGMAaAAgAGwAaQBtAGkAdAAgAGwAaQBhAGIAaQBs
'' SIG '' AGkAdAB5ACAAYQBuAGQAIABhAHIAZQAgAGkAbgBjAG8A
'' SIG '' cgBwAG8AcgBhAHQAZQBkACAAaABlAHIAZQBpAG4AIABi
'' SIG '' AHkAIAByAGUAZgBlAHIAZQBuAGMAZQAuMAsGCWCGSAGG
'' SIG '' /WwDFTAfBgNVHSMEGDAWgBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAdBgNVHQ4EFgQUVlMPwcYHp03X2G5XcoBQTOTs
'' SIG '' nsEwcQYDVR0fBGowaDAyoDCgLoYsaHR0cDovL2NybDMu
'' SIG '' ZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC10cy5jcmww
'' SIG '' MqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9z
'' SIG '' aGEyLWFzc3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5
'' SIG '' MHcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3Vy
'' SIG '' ZWRJRFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0B
'' SIG '' AQsFAAOCAQEALoOhRAVKBOO5MlL62YHwGrv4CY0juT3Y
'' SIG '' kqHmRhxKL256PGNuNxejGr9YI7JDnJSDTjkJsCzox+Hi
'' SIG '' zO3LeWvO3iMBR+2VVIHggHsSsa8Chqk6c2r++J/BjdEh
'' SIG '' jOQpgsOKC2AAAp0fR8SftApoU39aEKb4Iub4U5IxX9iC
'' SIG '' gy1tE0Kug8EQTqQk9Eec3g8icndcf0/pOZgrV5JE1+9u
'' SIG '' k9lDxwQzY1E3Vp5HBBHDo1hUIdjijlbXST9X/AqfI157
'' SIG '' 9JSN3Z0au996KqbSRaZVDI/2TIryls+JRtwxspGQo18z
'' SIG '' MGBV9fxrMKyh7eRHTjOeZ2ootU3C7VuXgvjLqQhsUwm0
'' SIG '' 9zCCBTEwggQZoAMCAQICEAqhJdbWMht+QeQF2jaXwhUw
'' SIG '' DQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQg
'' SIG '' QXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
'' SIG '' MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
'' SIG '' cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBD
'' SIG '' QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
'' SIG '' AL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0UzURB90Pl9
'' SIG '' TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcu
'' SIG '' HjvuzKb2Mln+X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/
'' SIG '' Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPuXciaC1TjqAlx
'' SIG '' a+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287Dxg
'' SIG '' aqwvB8z98OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn
'' SIG '' 5HU+upgPhH+fMRTWrdXyZMt7HgXQhBlyF/EXBu89zdZN
'' SIG '' 7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOC
'' SIG '' Ac4wggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd
'' SIG '' 823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5Bggr
'' SIG '' BgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
'' SIG '' Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0
'' SIG '' cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6
'' SIG '' oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0Rp
'' SIG '' Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0
'' SIG '' aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNybDBQBgNVHSAESTBHMDgG
'' SIG '' CmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6
'' SIG '' Ly93d3cuZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggEBAHGVEulRh1Zpze/d
'' SIG '' 2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysf
'' SIG '' DCFaKrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLo
'' SIG '' XoIlHsS6HHssIeLWWywUNUMEaLLbdQLgcseY1jxk5R9I
'' SIG '' EBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
'' SIG '' 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4Ui
'' SIG '' jGHKeZR+WfyMD+NvtQEmtmyl7odRIeRYYJu6DC0rbaLE
'' SIG '' frvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR79VYz
'' SIG '' Ii8iNrJLokqV2PWmjlIxggJNMIICSQIBATCBhjByMQsw
'' SIG '' CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
'' SIG '' MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
'' SIG '' VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGlt
'' SIG '' ZXN0YW1waW5nIENBAhAEzT+FaK52xhuw/nFgzKdtMA0G
'' SIG '' CWCGSAFlAwQCAQUAoIGYMBoGCSqGSIb3DQEJAzENBgsq
'' SIG '' hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAxMDA0
'' SIG '' MDAyMTAwWjArBgsqhkiG9w0BCRACDDEcMBowGDAWBBQD
'' SIG '' Jb1QXtqWMC3CL0+gHkwovig0xTAvBgkqhkiG9w0BCQQx
'' SIG '' IgQgg7vXfIXTcKB3TV2ePA3B5/LEB0YS/j0KRQ6iC9tw
'' SIG '' hyswDQYJKoZIhvcNAQEBBQAEggEAOGwxAjk6/KX3CTT9
'' SIG '' HjJ2NT45gDdn2qf6+iuPvhOL4LXp45wReiE14TP2asb/
'' SIG '' 405kKIJZN5zQuA6L6Sgf7fBcllOaVKhdXZvwk1lk9oPV
'' SIG '' UOptQl8Y/51P4Dr87dnUFPAVu2Xa0W3yAm/R6Ru8523y
'' SIG '' GpxmcoXLNJgDBRpFqUMmF/62Cu3w48ZmHroBgzZkmdyI
'' SIG '' tF5vzJ0U/BtdH5VOu0qfIk5lEem9LRmwxSxwDo4vWYuC
'' SIG '' V6nW1v9zeG8aDcltVWgOLaoAzjEUrPO8GIOY9AyT2tie
'' SIG '' lPVks9XgmDYQj/VwYv07eVwGH7neo57XWzlWHmMM5Ria
'' SIG '' uyQa2vUqH/x8YU2IaA==
'' SIG '' End signature block
